#ifndef __ETHERCATMASTERAPTASK_ERROR_H
#define __ETHERCATMASTERAPTASK_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// EtherCAT Master AP Packet Status codes (EtherCAT Master AP Task)
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_ETHERCAT_MASTER_AP_COMMAND_INVALID ((TLR_RESULT)0xC0640001L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_DPM_WATCHDOG_TIMEOUT_EXPIRED
//
// MessageText:
//
//  The watchdog expired.
//
#define TLR_E_ETHERCAT_MASTER_AP_DPM_WATCHDOG_TIMEOUT_EXPIRED ((TLR_RESULT)0xC0640002L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_WATCHDOG_TIME_TOO_SMALL
//
// MessageText:
//
//  The requested Watchdog time is too small.
//
#define TLR_E_ETHERCAT_MASTER_AP_WATCHDOG_TIME_TOO_SMALL ((TLR_RESULT)0xC0640003L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_WATCHDOG_TIME_TOO_LARGE
//
// MessageText:
//
//  The requested Watchdog time is too large.
//
#define TLR_E_ETHERCAT_MASTER_AP_WATCHDOG_TIME_TOO_LARGE ((TLR_RESULT)0xC0640004L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_WATCHDOG_RESET_ERROR
//
// MessageText:
//
//  Error during Reset (resetting watchdog).
//
#define TLR_E_ETHERCAT_MASTER_AP_WATCHDOG_RESET_ERROR ((TLR_RESULT)0xC0640005L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_CLEANUP_ERROR
//
// MessageText:
//
//  Error during Reset (cleanup the dynamic resources).
//
#define TLR_E_ETHERCAT_MASTER_AP_CLEANUP_ERROR ((TLR_RESULT)0xC0640006L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_CRITIAL_ERROR_STATE
//
// MessageText:
//
//  Master is in critical error state, reset required.
//
#define TLR_E_ETHERCAT_MASTER_AP_CRITIAL_ERROR_STATE ((TLR_RESULT)0xC0640007L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_WATCHDOG_ACTIVATE_ERROR
//
// MessageText:
//
//  Error activating the watchdog.
//
#define TLR_E_ETHERCAT_MASTER_AP_WATCHDOG_ACTIVATE_ERROR ((TLR_RESULT)0xC0640008L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_INPUT_DATA_TOO_LARGE
//
// MessageText:
//
//  Size of configured input data is larger than cyclic DPM input data size.
//
#define TLR_E_ETHERCAT_MASTER_AP_INPUT_DATA_TOO_LARGE ((TLR_RESULT)0xC0640009L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_OUTPUT_DATA_TOO_LARGE
//
// MessageText:
//
//  Size of configured output data is larger than cyclic DPM output data size.
//
#define TLR_E_ETHERCAT_MASTER_AP_OUTPUT_DATA_TOO_LARGE ((TLR_RESULT)0xC064000AL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_ENABLE_BUS_SYNC_FAILED
//
// MessageText:
//
//  Bus Synchronus mode could not be activated.
//
#define TLR_E_ETHERCAT_MASTER_AP_ENABLE_BUS_SYNC_FAILED ((TLR_RESULT)0xC064000BL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_TASK_CREATION_FAILED
//
// MessageText:
//
//  Task could not be created during runtime.
//
#define TLR_E_ETHERCAT_MASTER_AP_TASK_CREATION_FAILED ((TLR_RESULT)0xC064000CL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_DEVICE_ECS
//
// MessageText:
//
//  NXD: 1:1 relation broken DEVICE -> ECS.
//
#define TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_DEVICE_ECS ((TLR_RESULT)0xC064000DL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_CONTROLLER_ECM
//
// MessageText:
//
//  NXD: 1:1 relation broken DEVICE -> ECM.
//
#define TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_CONTROLLER_ECM ((TLR_RESULT)0xC064000EL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_ECS_MBX
//
// MessageText:
//
//  NXD: relation broken ECS -> MBX.
//
#define TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_ECS_MBX ((TLR_RESULT)0xC064000FL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_ECS_PROCESSDATA
//
// MessageText:
//
//  NXD: relation broken ECS -> PROCESSDATA.
//
#define TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_ECS_PROCESSDATA ((TLR_RESULT)0xC0640010L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_ECS_PREVIOUSPORT
//
// MessageText:
//
//  NXD: relation broken ECS -> PREVIOUSPORT.
//
#define TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_ECS_PREVIOUSPORT ((TLR_RESULT)0xC0640011L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_MBX_COE
//
// MessageText:
//
//  NXD: relation broken MBX -> COE.
//
#define TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_MBX_COE ((TLR_RESULT)0xC0640012L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_COE_INITCMDSCOE
//
// MessageText:
//
//  NXD: relation broken COE -> COEINITCMDS.
//
#define TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_COE_INITCMDSCOE ((TLR_RESULT)0xC0640013L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_CYCLIC_FRAME
//
// MessageText:
//
//  NXD: relation broken CYCLIC -> FRAME.
//
#define TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_CYCLIC_FRAME ((TLR_RESULT)0xC0640014L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_FRAME_CYCLICCMD
//
// MessageText:
//
//  NXD: relation broken FRAME -> CYCLICCMD.
//
#define TLR_E_ETHERCAT_MASTER_AP_BROKEN_RELATION_FRAME_CYCLICCMD ((TLR_RESULT)0xC0640015L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_INITCMDS
//
// MessageText:
//
//  NXD: interal error on INITCMD handing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_INITCMDS ((TLR_RESULT)0xC0640016L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_CYCLIC
//
// MessageText:
//
//  NXD: interal error on CYCLIC handing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_CYCLIC ((TLR_RESULT)0xC0640017L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_FRAME
//
// MessageText:
//
//  NXD: interal error on FRAME handing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_FRAME ((TLR_RESULT)0xC0640018L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_CYCLICCMD
//
// MessageText:
//
//  NXD: interal error on CYCLICCMD handing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_CYCLICCMD ((TLR_RESULT)0xC0640019L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_DEVICES
//
// MessageText:
//
//  NXD: interal error on DEVICES handing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_DEVICES ((TLR_RESULT)0xC0640020L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_STATE
//
// MessageText:
//
//  NXD: interal error, wrong state.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_STATE ((TLR_RESULT)0xC0640021L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_COE_INITCMD
//
// MessageText:
//
//  NXD: interal error on COE_INITCMD handing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_COE_INITCMD ((TLR_RESULT)0xC0640022L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_ECM
//
// MessageText:
//
//  NXD: interal error on ECM handing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_ECM ((TLR_RESULT)0xC0640023L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_SYNC
//
// MessageText:
//
//  NXD: interal error on SYNC handing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_INTERROR_SYNC ((TLR_RESULT)0xC0640024L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_CHDIR_FAILED
//
// MessageText:
//
//  NXD: Change Directory failed.
//
#define TLR_E_ETHERCAT_MASTER_AP_CHDIR_FAILED ((TLR_RESULT)0xC0640025L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_INVALID_INITCMD_LEN
//
// MessageText:
//
//  Invalid InitCmd length configuration
//
#define TLR_E_ETHERCAT_MASTER_AP_INVALID_INITCMD_LEN ((TLR_RESULT)0xC0640026L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_INVALID_CYCLICCMD_LEN
//
// MessageText:
//
//  Invalid CyclicCmd length configuration.
//
#define TLR_E_ETHERCAT_MASTER_AP_INVALID_CYCLICCMD_LEN ((TLR_RESULT)0xC0640027L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_CONFIG_BY_FILE
//
// MessageText:
//
//  Configuration is done by "ethercat.xml" or "config.nxd", packet interface inactive.
//
#define TLR_E_ETHERCAT_MASTER_AP_CONFIG_BY_FILE ((TLR_RESULT)0xC0640028L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_INVALID_COE_INITCMD_LEN
//
// MessageText:
//
//  Invalid CoE-InitCmd length configuration.
//
#define TLR_E_ETHERCAT_MASTER_AP_INVALID_COE_INITCMD_LEN ((TLR_RESULT)0xC0640029L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_CONTROLLERORADAPTER
//
// MessageText:
//
//  NXD: table CONTROLLERORADAPTER missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_CONTROLLERORADAPTER ((TLR_RESULT)0xC064002AL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_DEVICES
//
// MessageText:
//
//  NXD: table DEVICES missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_DEVICES ((TLR_RESULT)0xC064002BL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_ECM
//
// MessageText:
//
//  NXD: table ECM missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_ECM ((TLR_RESULT)0xC064002CL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_ECS
//
// MessageText:
//
//  NXD: table ECS missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_ECS ((TLR_RESULT)0xC064002DL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_INITCMDS
//
// MessageText:
//
//  NXD: table INITCMDS missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_INITCMDS ((TLR_RESULT)0xC064002EL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_CYCLIC
//
// MessageText:
//
//  NXD: table CYCLIC missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_CYCLIC ((TLR_RESULT)0xC064002FL)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_FRAME
//
// MessageText:
//
//  NXD: table FRAME missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_FRAME ((TLR_RESULT)0xC0640030L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_CYCLICCMD
//
// MessageText:
//
//  NXD: table CYCLICCMD missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_CYCLICCMD ((TLR_RESULT)0xC0640031L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_PROCESSDATA
//
// MessageText:
//
//  NXD: table PROCESSDATA missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_PROCESSDATA ((TLR_RESULT)0xC0640032L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_PREVIOUSPORT
//
// MessageText:
//
//  NXD: table PREVIOUSPORT missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_PREVIOUSPORT ((TLR_RESULT)0xC0640033L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_MBX
//
// MessageText:
//
//  NXD: table MBX missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_MBX ((TLR_RESULT)0xC0640034L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_COE
//
// MessageText:
//
//  NXD: table COE missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_COE ((TLR_RESULT)0xC0640035L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_INITCMDS_COE
//
// MessageText:
//
//  NXD: table INITCMDS_COE missing.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_IDENTIFY_FAILED_INITCMDS_COE ((TLR_RESULT)0xC0640036L)

//
// MessageId: TLR_E_ETHERCAT_MASTER_AP_NXD_NO_SLAVES_CONFIGURED
//
// MessageText:
//
//  At least one slave must be configured.
//
#define TLR_E_ETHERCAT_MASTER_AP_NXD_NO_SLAVES_CONFIGURED ((TLR_RESULT)0xC0640037L)




#endif  //__ETHERCATMASTERAPTASK_ERROR_H

